function isFirst(valoare, tab)
{
    try
        {
            var result = valoare.split(".");

            var index = tab.indexOf(result[1]);

            if(index === 0)
            {
                return true;
            } 
        }
        catch(Exception)
        {
            return false;
        }

    return false;
}

function checkDisplay(clasa,tab,valoare,state)
{

    var first = isFirst(valoare,tab);

    if(state)
    {
        try
        {
            var result = valoare.split(".");
            if(result[0] === clasa)
            {
                var index = tab.indexOf(result[1]);
                if( index !== -1 && index !== 0)
                {
                    var elName = clasa+'.'+tab[0];
                    $("input[type='checkbox'][value='"+elName+"']").prop('checked', true);
                }
            }
        }
        catch(Exception)
        {
            return false;
        }
    }
    else if(first)
    {
        uncheckAll(clasa);
    }
}

function uncheckAll(clasa)
{                    
    var checkboxes = $("input[type='checkbox'][class='"+clasa+"']");
    jQuery.each( checkboxes, function( i, val ) {
        $(val).prop('checked', false);
    });
}

var user        = ['userInfo', 'edit', 'add', 'change_state', 'user_pass', 'user_rights'];
var functie     = ['functieInfo', 'edit', 'add', 'delete','reatribuireFunc'];
var grup        = ['grupInfo', 'edit', 'add', 'delete','reatribuireGrup','editSef'];
var zona        = ['zonaInfo', 'edit', 'add', 'delete','reatribuireZona','editSef'];
var observatie  = ['observatieInfo', 'edit', 'add', 'delete','executare','productie'];
var punct       = ['punctInfo', 'edit', 'add', 'delete','',''];
var furnizor    = ['furnizorInfo', 'edit', 'add', 'delete','',''];
var reteta      = ['retetaInfo', 'edit', 'add', 'delete','',''];
//FRONTEND
var punct_front       = ['punctInfoFront', 'edit', 'add', 'delete','',''];
var furnizor_front    = ['furnizorInfoFront', 'edit', 'add', 'delete','',''];
var necesar_front     = ['necesarInfo', 'edit', 'add', 'delete','',''];
var comanda_front     = ['comandaInfo', 'edit', 'add', 'delete','',''];

$(document).ready(function(){
    $("input[type='checkbox']").change(function(){

        var clasa = $(this).attr('class');

        var value = $(this).val();

        var state = $(this).prop('checked');

        var tab = null;

        switch(clasa)
        {
            case 'user'         :   tab = user;         break;
            case 'functie'      :   tab = functie;      break;
            case 'grup'         :   tab = grup;         break;
            case 'zona'         :   tab = zona;         break;
            case 'observatie'   :   tab = observatie;   break;
            case 'punct'        :   tab = punct;        break;
            case 'furnizor'     :   tab = furnizor;     break;
            case 'reteta'       :   tab = reteta;       break;
            case 'punct_f'      :   tab = punct_front;        break;
            case 'furnizor_f'   :   tab = furnizor_front;     break;
            case 'necesare'     :   tab = necesar_front;      break;
            case 'comenzi'      :   tab = comanda_front;      break;
        }

        if(tab)
            checkDisplay(clasa,tab,value,state);

    });
});

