<?php

/**
 * 
 * Model pentru tabela 'utilizator' din baza de date.
 * 
 */
class User_model extends CI_Model{
    
    var $CI;
    
    function __construct() 
    {
        parent::__construct();
    }
    
    /**
     * 
     * Metoda care returneaza toti utilizatorii
     */
    function getUsers()
    {
        $query = 
            "
            SELECT U.*
            FROM utilizator as U
            WHERE  U.drept < 2;
            ;";
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
        
        return false;
    }
    
    /**
     * 
     * Metoda care returneaza informatiile unui utilizator.
     * 
     */
    function getUserInfo($userId)
    {
        $query = 
            "
            SELECT 
                U.*
            FROM utilizator as U
            WHERE U.id_utilizator = '$userId'
            ;";
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result()[0];
        
        return false;
    }
    
    /**
     * 
     * Metoda pentru activarea/dezactivarea unui utilizator.
     */
    function setUserState($id_utilizator, $state)
    {
        
        $s = $state ? 1:0;
        
        $query = 
            "
            UPDATE utilizator
            SET activ = '$s'
            WHERE id_utilizator = '$id_utilizator'
            ;";
        
        $update = $this->db->query($query);
       
        return $update;
    }
    
    /**
     * 
     * Metoda pentru adaugarea unui utilizator in baza de date.
     * 
     */
    function insertUser($new_user)
    {
        $insert = $this->db->insert('utilizator', $new_user);     
        return $insert;
    }
    
    /**
     * 
     * Metoda pentru actualizarea unui utilizator.
     * 
     */
    function updateUser($id_utilizator, $new_user)
    {
        $this->db->where('id_utilizator', $id_utilizator);
        $result= $this->db->update('utilizator', $new_user);
        return $result;
    }
 
    /**
     * 
     * Metoda care verifica daca un utilizator cu un anumit $username exista deja in baza de date.
     * 
     */
    function exists($username)
    {
        $q = $this->db->select('id_utilizator')->from('utilizator')->where('utilizator', $username)->get();
        if(isset($q) && $q!=null)
            if($q->num_rows() == 1)
                return true;
        return false;
    }
    
    /**
     * 
     * Metoda pentru preluarea tuturor utilizatorilor activi din baza de date.
     * 
     */
    function getActiveUsers()
    {
        $query = 
            "
            SELECT U.id_utilizator, U.utilizator, U.nume, U.prenume, U.data_adaugare, U.activ
            FROM utilizator as U WHERE U.activ = 1;";
    
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
        
        return false;
    }
    

}


?>