<?php

/**
 * 
 * Model pentru document
 * 
 */
class Document_model extends CI_Model{
    
    function __construct() 
    {
        parent::__construct();
    }

    function getAllData($start=NULL,$limit=NULL,$sidx=NULL,$sord=NULL,$where=NULL)
    {
        $ci = &get_instance();

        $q_w = ' 1 ';
        if($where != NULL)
            $q_w = $where;

        $query = 
            "
            SELECT  I.*, S.denumire as sts, S.class, SS.denumire as sta
            FROM document as I
            LEFT JOIN status as S on S.id_status=I.status
            LEFT JOIN stare as SS on SS.id_stare=I.stare
            WHERE $q_w ";
       
        if(isset($sidx) && isset($sord))
        	$query.=" ORDER BY $sidx $sord";
         
        if(isset($limit) && $limit)
            $query.=" LIMIT  $start ,$limit";


        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
        
        return false;
    }

    function getInfoDocument($id)
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $query = 
            "
            SELECT I.*, S.denumire as sts, SS.denumire as sta
            FROM document as I
            LEFT JOIN status as S on S.id_status=I.status
            LEFT JOIN stare as SS on SS.id_stare=I.stare
            WHERE I.id_document = ".$ci->db->escape($id);
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result()[0];
            
        return false;
    }

    function getInfoDocumentIntrare($id)
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $query = 
            "
            SELECT I.*, S.denumire as sts, SS.denumire as sta
            FROM document as I
            LEFT JOIN status as S on S.id_status=I.status
            LEFT JOIN stare as SS on SS.id_stare=I.stare
            WHERE I.id_document = ".$ci->db->escape($id);
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result()[0];
            
        return false;
    }

    function getStatus($client=NULL)
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $query = 
            "
            SELECT I.*
            FROM status as I
            WHERE I.activ>0";
        
        if(isset($client) && $client)
            $query.=" AND I.client>0";
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
            
        return false;
    }

    function getStare()
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $query = 
            "
            SELECT I.*
            FROM stare as I
            WHERE I.activ>0";
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
            
        return false;
    }

    function getClienti()
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $query = 
            "
            SELECT I.*
            FROM client as I
            WHERE I.activ>0";
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
            
        return false;
    }

    //status permisiuni documente
    function getDocumente($sts=NULL,$in=NULL)
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        if(isset($sts) && $sts)
            $qq =" AND I.status=".$sts;
            
        if(isset($in) && $in)
        	$qq =" AND (I.status=".$in." OR I.status=".$sts.")";

        $query = 
            "
            SELECT I.*
            FROM document as I
            WHERE I.activ>0".$qq;

        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
            
        return false;
    }
}