<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
//clasa info email, login


class Login_library {

	/**
     * 
     * Metoda care verifica daca utilizatorul curent este logat in sistem.
     * 
     * @return boolean
     */
    function loggedIn()
    {
        $ci = &get_instance();

        $logged_in = $ci->session->userdata('is_logged_in');
        return (isset($logged_in) && $logged_in);
    }

    /**
     * 
     * Metoda care preia o valoare din sesiune dupa nume.
     * 
     */
    function getSession($name, $value)
    {
        $ci = &get_instance();
        $session = $ci->session->userdata($name);
        if($session)
            return $session[$value];
        return false;
    }
    
    /**
     * 
     * Metoda care returneaza id-ul utilizatorului $username.
     */
    function getUserId($username)
    {
        $ci = &get_instance();
        $query = "SELECT id_utilizator FROM utilizator WHERE utilizator = '$username';";
        $q = $ci->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() == 1)
                return $q->result()[0]->id_utilizator;
        return false;
    }
    
    /**
     * 
     * Metoda care returneaza is admin utilizator a persoanei autentificate.
     * 
     */
    function isAdmin()
    {
        $ci = &get_instance();

        $username = $this->getUsername();

        $query = " SELECT U.id_utilizator FROM utilizator as U WHERE U.drept > 0 AND U.utilizator= ".$ci->db->escape($username);
    
        $q = $ci->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return true;
        
        return false;
    }

    /**
     * 
     * Metoda care returneaza isSuperadmin
     * 
     */
    function isSuperadmin()
    {
        $ci = &get_instance();
        $user_id = $this->getId();
        $q  = $ci->db->query("SELECT id_utilizator FROM utilizator WHERE drept=1 AND id_utilizator = '$user_id';");
        if(isset($q) && $q!=null)
            if($q->num_rows == 1)
                return $q->result()[0]->id_utilizator;
        return false;
    }

    /**
     * 
     * Metoda care returneaza numele de utilizator a persoanei autentificate.
     * 
     */
    function getUsername()
    {
        return $this->getSession('is_logged_in', 'username');
    }
    
    /**
     * 
     * Metoda care returneaza numele de utilizator a persoanei cu id-ul $user_id din baza de date.
     * 
     */
    function getUser($user_id)
    {
        $ci = &get_instance();
        $q = $ci->db->select('utilizator')->from('utilizator')->where('id_utilizator', $user_id)->get();
        if(isset($q) && $q!=null)
            if($q->num_rows() == 1)
                return $q->result()[0]->utilizator;
        return false;
    }
    
    /**
     * 
     * Metoda care returneaza numele complet (Nume Prenume) al unei persoane dupa id.
     */
    function getName($user_id)
    {
        $ci = &get_instance();
        $q  = $ci->db->query("SELECT nume AS denumire FROM utilizator WHERE id_utilizator = '$user_id';");
        if(isset($q) && $q!=null)
            if($q->num_rows() == 1)
                return $q->result()[0]->denumire;
        return false;
    }

    /**
     * 
     * Metoda care trimite email
     */
    function sendEmailFile($email, $subject, $titlu, $message, $doc)
    {
        $ci = &get_instance();
        $ci->load->library('mailer');
        $ci->load->model('generale_model');

        $doc_root = dirname($_SERVER['DOCUMENT_ROOT'], 1);

        $infoEmail  = $ci->generale_model->getInfoEmail();
        $infoConfig = $ci->generale_model->getInfoConfig();
        $new_path   = (isset($infoConfig) && $infoConfig->new_path)?$doc_root.$infoConfig->new_path:$doc_root."/docs.devsrv01.oneit.cloud/nextclouddata/dev/files/TRIMISE/";

        $mailer = new PHPMailer();
        
        $mailer->addCustomHeader('MIME-Version: 1.0');
        //$mailer->addCustomHeader('Reply-To', $email_cc.' <'.$email_cc.'>');

        $mailer->isSMTP();
        
        $mailer->SMTPDebug  = 0;  
        $mailer->IsHTML(false); 

        //date email
        $mailer->SMTPAuth   = true;      
        $mailer->Host       = (isset($infoEmail) && $infoEmail->host)?$infoEmail->host:'';  
        $mailer->Port       = (isset($infoEmail) && $infoEmail->port)?$infoEmail->port:'';   
        $mailer->Username   = (isset($infoEmail) && $infoEmail->username)?$infoEmail->username:''; 
        $mailer->Password   = (isset($infoEmail) && $infoEmail->password)?$infoEmail->password:'';   
        $mailer->SMTPSecure = 'ssl';
        
        $from       = (isset($infoEmail) && $infoEmail->username)?$infoEmail->username:''; 
        $from_name  = (isset($infoEmail) && $infoEmail->from_name)?$infoEmail->from_name:'';
        
        $mailer->AddBCC($from, $from_name);
        
        //Typical mail data
        $mailer->IsHTML(true);  
        $mailer->AddAddress($email);
        $mailer->SetFrom($from, $from_name);
        $mailer->Subject = $subject;
        
        $data['email']   = $email;
        $data['titlu']   = $titlu;
        $data['content'] = $message;

        $template = $ci->load->view('email', $data, true);
        
        $mailer->Body = $template;
        
        $mailer->msgHTML($template);

        if(isset($doc) && $doc)
            $mailer->AddAttachment($new_path.$doc);   
        
        try{
            $mailer->Send();
        } catch(Exception $e){
            //Something went bad
            echo "Fail - " . $ci->mailer->ErrorInfo;
        }

        $mailer->ClearAllRecipients();   
    }

    function sendEmail($email, $subject, $titlu, $message, $cc=TRUE)
    {
        $ci = &get_instance();
        $ci->load->library('mailer');

        $mailer = new PHPMailer();
        
        $mailer->isSMTP();
        
        $mailer->SMTPDebug  = 0;  

        //date email
        $mailer->SMTPAuth   = true;      
        $mailer->Host       = 'mail.abc.eu';  
        $mailer->Port       = 465;  
        $mailer->Username   = 'suport@abc.eu';  
        $mailer->Password   = 'abc';  
        $mailer->SMTPSecure = 'ssl';
        
        $from = 'suport@abc.eu'; 

        //Typical mail data
        $mailer->IsHTML(true);  
        $mailer->AddAddress($email);
        $mailer->SetFrom($from, 'Suport');
        $mailer->Subject = $subject;
        
        $data['email']   = $email;
        $data['titlu']   = $titlu;
        $data['content'] = $message;
        
        $template = $ci->load->view('email', $data, true);
        
        $mailer->Body = $template;

        
        try{
            $mailer->Send();
        } catch(Exception $e){
            //Something went bad
            echo "Fail - " . $ci->mailer->ErrorInfo;
        }
        
        $mailer->ClearAllRecipients(); 
    }

     /**
     * 
     * Metoda care returneaza id-ul utilizatorului autentificat.
     */
    function getId()
    {
        $username = $this->getUsername();
        return $this->getUserId($username);
    }

    /**
     * 
     * Metoda care returneaza info utilizatorului autentificat.
     */
    function getInfoUserLogin()
    {
        $ci = &get_instance();

        $username = $this->getUsername();

        $q  = $ci->db->query("SELECT * FROM utilizator WHERE utilizator = '$username';");
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result()[0];
        return false;
    }
    
    /**
     * 
     * Metoda pentru preluarea parolei unui utilizator cu id-ul $userId.
     * 
     */
    function getPass($userId)
    {
        $ci = &get_instance();
        $q = $ci->db->select('parola')->from('utilizator')->where('id_utilizator', $userId)->get();
        if(isset($q) && $q!=null)
            if($q->num_rows() == 1)
                return $q->result()[0]->parola;
        return false;
    }
    
    /**
     * 
     * Metoda care verifica egalitatea a 2 parole.
     */
    function samePass($userId, $pass)
    {
        $pass = hash('sha512', $pass);
        $db_pass = $this->getPass($userId);
        
        return !strcmp($pass,$db_pass);
    }
    
    /**
     * 
     * Metoda pentru modificarea parolei unui utilizator.
     * 
     * @param int $userId Id-ul utilizatorului
     * @param string $new_pass Noua parola ce se doreste a fi setata
     */
    function changePass($userId, $new_pass)
    {
        $ci = &get_instance();
        $new_pass = hash('sha512', $new_pass);
        return $ci->db->where('id_utilizator', $userId)->update('utilizator', array('parola' => $new_pass));
    }

}
?>