<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * 
 * Controller pentru gestionarea obiectelor din HomePage.
 * 
 */
class Setari extends MY_Controller{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->model('generale_model');
        $this->load->library('global_library');

        // if(!$this->login_library->isSuperadmin())
        //     redirect('user/info');
    }
    
    /**
     * 
     * Metoda pentru setari email
     * 
     */
    function index($info=array())
    {
        $infoGenerale = $this->generale_model->getInfoEmail();

        $data['title']        = "Setari email";

        if(count($info))
            $data['info'] = $info;

        $data['infoGenerale'] = $infoGenerale;

        $this->load->view('admin/generale/view.php', $data);
    }

    //save email config
    function save()
    {
        $host               = $this->input->post('host');
        $port               = $this->input->post('port');
        $username           = $this->input->post('username');
        $password           = $this->input->post('password');
        $from_name          = $this->input->post('from_name');
        $subject_email      = $this->input->post('subject_email');
        $body_email         = $this->input->post('body_email');

        if(isset($host) && $host && isset($username) && $username && isset($password) && $password)
        {
            $infoGenerale = $this->generale_model->getInfoEmail();

            $content = array(
                                'host'                 => $host,
                                'port'                 => $port,
                                'username'             => $username,
                                'password'             => $password,
                                'from_name'            => $from_name,
                                'subject_email'        => $subject_email,
                                'body_email'           => $body_email,
                                'date_edit'            => date("Y-m-d H:i:s")
                            );

            if(isset($infoGenerale) && $infoGenerale)
            {      
                $this->db->update('setari_email',$content);    
                $msg="update";
                $this->index(array('info' => 'Actualizare cu succes!'));
            }
            else
            {
                $this->db->insert('setari_email', $content);    
                $msg="insert";
                $id = $this->db->insert_id();
                $this->index(array('info' => 'Inregistrare cu succes!'));
            }
            
            //redirect("adm/setari?m=".$msg);
        }
        else{
            $this->index(array('eroare' => 'Eroare formular!'));
        }
    }

    //display page config
    function config($info=array())
    {
        $infoGeneraleConfig         = $this->generale_model->getInfoConfig();

        $data['title']              = "Setari config";

        if(count($info))
            $data['info'] = $info;

        $data['infoGeneraleConfig'] = $infoGeneraleConfig;

        $this->load->view('admin/generale/config.php', $data);
    }

    //save config
    function save_config()
    {
        $path               = $this->input->post('path');
        $new_path           = $this->input->post('new_path');
        $sep                = $this->input->post('sep');

        if(isset($new_path) && $new_path && isset($path) && $path)
        {
            $infoGeneraleConfig = $this->generale_model->getInfoConfig();

            $content = array(
                                'path'                 => $path,
                                'new_path'             => $new_path,
                                'separator'            => $sep,
                                'date_edit'      => date("Y-m-d H:i:s")
                            );

            if(isset($infoGeneraleConfig) && $infoGeneraleConfig)
            {      
                $this->db->update('setari_config',$content);    
                $msg="update";
                $this->config(array('info' => 'Actualizare cu succes!'));
            }
            else
            {
                $this->db->insert('setari_config', $content);    
                $msg="insert";
                $id = $this->db->insert_id();
                $this->config(array('info' => 'Inregistrare cu succes!'));
            }
            
            //redirect("adm/setari/config?m=".$msg);
        }
        else{
            $this->config(array('eroare' => 'Eroare formular!'));
        }
    }

}