<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * 
 * Controller pentru gestionarea Scan
 * 
 */
class Scan extends MY_Controller{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->model('document_model');
        $this->load->model('arhiva_model');
        $this->load->library('login_library');
    }

    /**
     * 
     * Metoda pentru afisarea paginii Scan.
     * 
     * 
     */
    function index()
    {
        $data['title'] = "Istoric document";

        //jqgrid item
        $status         = 'Status';
        $doc            = 'Document';
        $client         = 'Client';
        $cod            = 'Barcode';
        $obs            = 'Observatii';
        $data_adaugare  = 'Data adaugare';
 
        $colModel_Items = "[
                        {name:'S.denumire',index:'S.denumire',  groupOp:'and', width:'100', align:'center'},
                        {name:'I.denumire',index:'I.denumire',  groupOp:'and', width:100, align:'left'},
                        {name:'I.client',index:'I.client',  groupOp:'and', width:100, align:'center'},
                        {name:'I.',index:'I.id_document',  groupOp:'and', width:100, align:'center'},
                        {name:'I.observatii',index:'I.observatii',  groupOp:'and', width:'100', align:'center'},
                        {name:'I.data_adaugare',index:'I.data_adaugare',  groupOp:'and', width:'100', align:'center'}
                  ]";

        $colNames_Items = "['".$status."', '".$doc."', '".$client."', '".$cod."','".$obs."','".$data_adaugare."']";
        
        $data['colModel'] = $colModel_Items;
        $data['colNames'] = $colNames_Items;

        $this->load->view('admin/scan/scan_page', $data);
    }

    // load documente
    function loadData($slug=NULL)
    {
        $id_document = $slug;
        if(isset($id_document) && $id_document)
        {
            $page = isset($_POST['page'])?$_POST['page']:1; 
            $limit = isset($_POST['rows'])?$_POST['rows']:10; 
            $sidx = isset($_POST['sidx'])?$_POST['sidx']:'denumire'; 
            $sord = isset($_POST['sord'])?$_POST['sord']:'';         
            $start = $limit*$page - $limit; 
            $start = ($start<0)?0:$start; 
            $responce = (object)array();
            $where = " 1 "; 
            
            $searchField = isset($_POST['searchField']) ? $_POST['searchField'] : false;
            $searchOper = isset($_POST['searchOper']) ? $_POST['searchOper']: false;
            $searchString = isset($_POST['searchString']) ? $_POST['searchString'] : false;
            
            $ops_array = array(
                'eq'=>'=', 
                'ne'=>'<>',
                'lt'=>'<', 
                'le'=>'<=',
                'gt'=>'>', 
                'ge'=>'>=',
                'bw'=>'LIKE',
                'bn'=>'NOT LIKE',
                'in'=>'LIKE', 
                'ni'=>'NOT LIKE', 
                'ew'=>'LIKE', 
                'en'=>'NOT LIKE', 
                'in'=>'LIKE', 
                'ni'=>'NOT LIKE', 
                'ew'=>'LIKE', 
                'en'=>'NOT LIKE', 
                'cn'=>'LIKE', 
                'nc'=>'NOT LIKE' 
                );
            
            if ($_POST['_search'] == 'true') {
                
                if(isset($searchField) && $searchString)
                {
            
                foreach ($ops_array as $key=>$value){
                    if ($searchOper==$key) {
                        $ops = $value;
                    }
                }
                if($searchOper == 'eq' ) $searchString = $searchString;
                if($searchOper == 'bw' || $searchOper == 'bn') $searchString .= '%';
                if($searchOper == 'ew' || $searchOper == 'en' ) $searchString = '%'.$searchString;
                if($searchOper == 'cn' || $searchOper == 'nc' || $searchOper == 'in' || $searchOper == 'ni') $searchString = '%'.$searchString.'%';

                $where = "$searchField $ops '$searchString' ";
                }
                
                $filters = json_decode($this->input->post('filters'), true);  
                $groupOp = $filters['groupOp'];  
                if(isset($filters))
                {
                    $where = ' 1 ';
                    $ops1  = ' AND ';
                    foreach ( $filters['rules'] as $item){ 
                        $searchField = $item['field'];
                        $searchOper = $item['op'];
                        $searchString = $item['data'];
                        
                        foreach ($ops_array as $key=>$value){
                            if ($searchOper==$key) {
                                $ops1 = $value;
                            }
                        }
                        if ($searchOper == 'eq')
                            $searchString = $searchString;
                        if ($searchOper == 'bw' || $searchOper == 'bn')
                            $searchString .= '%';
                        if ($searchOper == 'ew' || $searchOper == 'en')
                            $searchString = '%' . $searchString;
                        if ($searchOper == 'cn' || $searchOper == 'nc' || $searchOper == 'in' || $searchOper == 'ni')
                            $searchString = '%' . $searchString . '%';
                        
                        $where .= $groupOp." $searchField $ops1 '$searchString' ";
                    }
                }

            }

            if(!$sidx) 
                $sidx =1;
            
            $all_results = $this->arhiva_model->getAllDataScan($id_document);
            $count = count($all_results);  
            
            if( $count > 0 ) {
                $total_pages = ceil($count/$limit);    
            } else {
                $total_pages = 0;
            }

            if ($page > $total_pages) 
                $page=$total_pages;
            
            $base = base_url();
            
            $query = $this->arhiva_model->getAllDataScan($id_document,$start,$limit,$sidx,$sord,$where); 
            
            $responce->page = $page;
            $responce->total = $total_pages;
            $responce->records = $count;
            $i=0;
            $c=1;
            if(isset($query) && $query)
                foreach($query as $row) {
                  
                $doc            = $row->denumire;  
                $client         = ($row->client)? $row->client:"Arhiva"; 

                $href_cod       = base_url()."adm/arhiva/barcode/".$row->id_document;
                $cod            = $row->id_document;  

                $status         = "<p class='$row->class'>".$row->sts."</p>";  
                $data_adaugare  = $row->data_adaugare;
                $obs            = $row->observatii;

                $optiuni        = '';

                $responce->rows[$i]['id_client_document']=$row->id_client_document;
                $responce->rows[$i]['cell']=array($status, $doc, $client, $cod, $obs, $data_adaugare);
                $i++;
                $c++;
            }

            echo json_encode($responce);
        }
    }

    function check()
    {
        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
        }
        $result      = 'Nu exista informatii!';
        $cod         = $this->input->post('cod');

        $infoDoc     = $this->document_model->getInfoDocument($cod);
        if(isset($infoDoc) && $infoDoc)
        {
            $result = "<p>Informatii curente document:</p>";
            $result .= "<p><b>Denumire:</b> ".$infoDoc->denumire."</p>";
            $result .= "<p><b>Descriere:</b> ".$infoDoc->descriere."</p>";
            $result .= "<p><b>Status:</b> ".$infoDoc->sts."</p>";
            $result .= "<p><b>Stare:</b> ".$infoDoc->sta."</p>";
        }
        echo $result;
    }
}